/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.datapack;

import io.github.noeppi_noeppi.libx.datapack.DatapackHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathResourcePack;

public class LibXDatapack
extends PathResourcePack {
    public static final int PACK_VERSION = 9;
    public static final String PREFIX = "libxdata";
    private final String packId;
    private final Supplier<InputStream> packMcmeta;

    public LibXDatapack(IModFile mod, String packId) {
        super(mod.getFileName() + "/" + packId, mod.findResource(new String[]{PREFIX}));
        this.packId = packId;
        this.packMcmeta = DatapackHelper.generatePackMeta(mod, "Dynamic Datapack: " + mod.getFileName() + "/" + packId);
    }

    protected boolean m_6105_(@Nonnull String name) {
        return name.equals("pack.mcmeta") || super.m_6105_(name);
    }

    public boolean m_7211_(@Nonnull PackType type, @Nonnull ResourceLocation location) {
        return this.resourceValid(type, location) && super.m_7211_(type, location);
    }

    @Nonnull
    protected InputStream m_5541_(@Nonnull String name) throws IOException {
        return name.equals("pack.mcmeta") ? this.packMcmeta.get() : super.m_5541_(name);
    }

    @Nonnull
    public InputStream m_8031_(@Nonnull PackType type, @Nonnull ResourceLocation location) throws IOException {
        if (this.resourceValid(type, location)) {
            return super.m_8031_(type, location);
        }
        throw new FileNotFoundException(type.m_10305_() + "/" + location.m_135827_() + "/" + location.m_135815_() + "@" + this.m_8017_());
    }

    private boolean resourceValid(PackType type, ResourceLocation location) {
        return type == PackType.SERVER_DATA || location.m_135815_().startsWith("lang/");
    }

    public boolean isHidden() {
        return true;
    }

    @Nonnull
    protected Path resolve(String ... pathParts) {
        String[] paths;
        String pathStr = switch (pathParts.length) {
            case 0 -> "";
            case 1 -> pathParts[0];
            default -> {
                StringBuilder sb = new StringBuilder();
                for (String pathPart : pathParts) {
                    sb.append("/").append(pathPart);
                }
                yield sb.toString();
            }
        };
        while (pathStr.contains("//")) {
            pathStr = pathStr.replace("//", "/");
        }
        if (pathStr.startsWith("/")) {
            pathStr = pathStr.substring(1);
        }
        if (pathStr.endsWith("/")) {
            pathStr = pathStr.substring(0, pathStr.length() - 1);
        }
        if ((paths = pathStr.split("/")).length == 0) {
            return this.getSource().resolve(this.packId);
        }
        Path path = switch (paths[0]) {
            case "pack.mcmeta" -> this.getSource();
            case "data" -> this.getSource().resolve(this.packId);
            default -> this.getSource().resolve(this.packId).resolve("SNOWBALL");
        };
        for (int i = 1; i < paths.length; ++i) {
            path = path.resolve(paths[i]);
        }
        return path;
    }
}

